package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.bizobj.AccessFeatureBO;
import gov.va.med.mhv.usermgmt.bizobj.AccessRoleAccessControlBO;
import gov.va.med.mhv.usermgmt.bizobj.AccessRoleBO;
import gov.va.med.mhv.usermgmt.bizobj.AccessRoleBaseBO;
import gov.va.med.mhv.usermgmt.bizobj.UserProfileAccessControlBO;
import gov.va.med.mhv.usermgmt.service.AccessControlCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.AccessControlService;
import gov.va.med.mhv.usermgmt.service.AccessFeatureCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.AccessFeatureServiceResponse;
import gov.va.med.mhv.usermgmt.service.AccessRoleCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.AccessControl;
import gov.va.med.mhv.usermgmt.transfer.AccessRole;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.util.AccessControlUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Service implementation class for the AccessControl service
 * @see gov.va.med.mhv.usermgmt.service.AccessControlService
 */
public class AccessControlServiceImpl implements AccessControlService {
    
    private static final Log LOG = LogFactory.getLog(AccessControlServiceImpl.
        class);

	/**
	 * Execute the FindAccessControls service
	 * @see gov.va.med.mhv.usermgmt.service.AccessControlService#
     * findAccessControls()
	 */
	@SuppressWarnings("unchecked")
    public AccessControlCollectionServiceResponse findAccessControls(
        String userName) 
    {
        Precondition.assertNotBlank("userName", userName);
        userName = StringUtils.lowerCase(userName);
		AccessControlCollectionServiceResponse response = 
            new AccessControlCollectionServiceResponse();

        Map<String, AccessControl> accessControls = 
            new HashMap<String, AccessControl>();
        
        // UserProfile-based Access Control has precedence 
        // over AccessRole-based AccessControl, so add them first 
        List userBasedControls = UserProfileAccessControlBO.
            findUserProfileAccessControlByUserName(userName);
        LOG.debug("Size of userBasedControls: " + userBasedControls.size());
        if(userBasedControls !=null && userBasedControls.size() > 0){
        for (Object c: userBasedControls) {
            UserProfileAccessControlBO userBasedControl =
                (UserProfileAccessControlBO) c;
            if(userBasedControl!=null){
            	LOG.debug("UserBasedControl feature: " + userBasedControl.getFeature());
            	accessControls.put(createKey(userBasedControl.getFeature()), 
                toAccessControl(userBasedControl));
            }else{
            	LOG.debug(" *** UserBasedControl is null ***");
            }
        }
    }else{
    	LOG.debug(" *** userBasedControls list is null ***");
    }
        
        List roleBasedControls = AccessRoleAccessControlBO.
            findAccessRoleAccessControlByUserName(userName);
        if(roleBasedControls !=null && roleBasedControls.size() > 0){
	        for (Object c: roleBasedControls) {
	            AccessRoleAccessControlBO roleBasedControl = 
	                (AccessRoleAccessControlBO) c;
		            if(roleBasedControl!=null){
			            String key = createKey(roleBasedControl.getFeature()); 
			            if (accessControls.get(key) == null) {
			                accessControls.put(key, toAccessControl(roleBasedControl));
			            } else if (LOG.isDebugEnabled()) { 
			                LOG.debug("Ignoring '" +  roleBasedControl.getRole().getName() 
			                    + "' Role-based control, because already found a "
			                    + "UserProfile-based control for feature " + key);
			            }
		        }else{
		        	LOG.debug(" *** roleBasedControl is null ***");
		        }
	        }
        }else{
        	LOG.debug(" *** roleBasedControls list is null ***");
        }

        response.addItems(accessControls.values());

        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + AccessControlUtils.describe(
                response.getAccessControls()) + " for '" + userName + "'");
        }

		return response;
	}

    @SuppressWarnings("unchecked")
	public AccessFeatureCollectionServiceResponse getAllAccessFeatures() {
    	AccessFeatureCollectionServiceResponse response = 
    		new AccessFeatureCollectionServiceResponse();
    	List<AccessFeatureBO> bos = AccessFeatureBO.findAllAccessFeatures();
    	if (bos != null) {
    		for (AccessFeatureBO bo: bos) {
    			response.addAccessFeature(bo.getAccessFeatureValues());
    		}
    	}
    	return response;
    }
    

    @SuppressWarnings("unchecked")
	public AccessFeatureServiceResponse findAccessFeature(
    	String featureName) 
    {
    	AccessFeatureServiceResponse response = 
    		new AccessFeatureServiceResponse();
    	List<AccessFeatureBO> bos = AccessFeatureBO.findAccessFeature(
    		featureName);
    	if (bos != null) {
    		Iterator<AccessFeatureBO> i = bos.iterator(); 
    		if ((i != null) && i.hasNext()) {
    			response.setAccessFeature(i.next().getAccessFeatureValues());
    		}
    	}
    	return response;
    	
    }    
    
    private static AccessControl toAccessControl(UserProfileAccessControlBO 
        userBasedControl)
    {
        assert userBasedControl != null;
        AccessControl accessControl = TransferObjectFactory.
            createAccessControl();
        accessControl.setFeature(userBasedControl.getFeature().
            getAccessFeatureValues());
        accessControl.setPermissions(userBasedControl.getPermissions());
        accessControl.setRoleId(null);
        accessControl.setUserProfileId(userBasedControl.getUserProfile().
            getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tAdd " + AccessControlUtils.describe(accessControl));
        }
        return accessControl;
    }
    
    private static AccessControl toAccessControl(AccessRoleAccessControlBO 
        roleBasedControl)
    {
        assert roleBasedControl != null;
        AccessControl accessControl = TransferObjectFactory.
            createAccessControl();
        accessControl.setFeature(roleBasedControl.getFeature().
            getAccessFeatureValues());
        accessControl.setPermissions(roleBasedControl.getPermissions());
        accessControl.setRoleId(roleBasedControl.getRole().getId());
        accessControl.setUserProfileId(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tAdd " + AccessControlUtils.describe(accessControl));
        }
        return accessControl;
    }

    private static String createKey(AccessFeatureBO accessFeature) {
        assert accessFeature != null;
        LOG.debug("*** AccessDomain: " + accessFeature.getDomain().getName());
        if(accessFeature.getDomain()!=null){
        return accessFeature.getDomain().getName() + "::" + accessFeature.
            getName();
        }
        else{
        	LOG.debug("*** accessFeature.getDomain() is null");
        	return accessFeature.getName();
        }
    }    
    
}